\name{MC.analysis}
\alias{MC.analysis}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Analysis of the Monte Carlo simulation
}
\description{
  Function for running the analysis of the Monte Carlo simulation.
}
\usage{
  MC.analysis(x, delta, qUpper, p1.det, sim.det, event.ini, event.end, ntick, summ.data = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
    A \code{list} .}
  \item{delta}{
    A \code{numeric} value that specifies the level of aggregation required in minutes.}
  \item{qUpper}{
    A \code{character} string that defines the upper percentile to plot the confidence band of results,
    several options are possible \code{"q999"} the 99.9th percentile, \code{"q995"} the 99.5th percentile,
    \code{"q99"} the 99th percentile, \code{"q95"} the 95th percentile, \code{"q50"} the 50th percentile.
    The lower boundary of the confidence band (showed in gray in the output plots) is the 5th percentile 
    in all cases.}
  \item{p1.det}{
    A \code{data.frame} that contains the time series of the 
    main driving force of the system to be simulated deterministically, e.g. precipitation. This 
    data.frame should have 
    only two columns: the first one, Time [y-m-d h:m:s]; the second one, a numeric value equal to the magnitude
    of the environmental variable.}
  \item{sim.det}{
    A \code{list} that contains the results of the deterministic simulation, here the output of EmiStatR given
    \code{p1.det}. See the method \code{EmiStatR} from the homonym package for details.}
  \item{event.ini}{
    A time-date string in \code{POSIXct} format that defines the initial time for event analysis. }
  \item{event.end}{
    A time-date string in \code{POSIXct} format that defines the final time for event analysis.}
  \item{ntick}{
    A \code{numeric} value to specify the number of ticks in the x-axis for the event time-window plots.}
  \item{summ}{
    A \code{list} by default NULL. If provided, the list should contain an output of the MC.analysis function,   
    and the analysis is done again without the calculation of some of the internal variables, therefore the 
    analysis is faster.}
}
%\details{
  %%  ~~ If necessary, more details than the description above ~~
    %}
\value{
  A \code{list} of length 2:
  \item{summ }{A \code{list} that contains the summary statistics of the Monte Carlo simulation per output
  variable. Each output variable is summarised by calculating the mean \code{"Mean"}, standard deviation
  \code{"sd"}, variance \code{"Variance"}, 5th, 25th, 50th, 75th, 95th, 99.5th, 99.9th percentiles 
  \code{"q05", "q25", "q50", "q75", "q95", "q995"}, \code{"q999"}, the max \code{"Max"}, the sum \code{"Sum"}, 
  time \code{"time"}, and the deterministic precipitation \code{"p1"}, all variables as time series.}
  \item{variance }{A \code{data.frame} that contains the summary statistics of the variance of the Monte 
  Carlo simulation per output variable.}
}
%\references{
  %% ~put references to the literature/web site here ~
    %}
\author{
  J.A. Torres-Matallana
}
%\note{
%  
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~
  
  \seealso{
    See also \code{\link{setup}}, \code{\link{MC.setup}}, \code{\link{MC.sim}}.
  }
\examples{
## the Monte Carlo simulation
library(EmiStatR)
data(P1)

library(STUnc)

setting_EmiStatR <-  setup(id       = "MC_sim1",
                           nsim     = 15,
                           seed     = 0.7010607, 
                           mcCores  = 1, 
                           ts.input = P1,  
                           rng      = rng <- list(
                             qs   = 150,    # [l/PE/d]
                             CODs = c(pdf = "nor", mu = 4.378, sigma = 0.751),    # [g/PE/d]
                             NH4s = c(pdf = "nor", mu = 1.473, sigma = 0.410),    # [g/PE/d]
                             qf   = 0.05,     # [l/s/ha]
                             CODf = 0,              # [g/PE/d]
                             NH4f = 0,              # [g/PE/d]
                             CODr = c(pdf = "nor", mu = 3.60, sigma = 1.45),     # [mg/l]
                             NH4r = 2,              # [mg/l]
                             tf   = 20,          # [min]
                             nameCSO = "E1",        # [-]
                             id      = 1,           # [-]
                             ns      = "FBH Goesdorf",  # [-]
                             nm      = "Goesdorf",  # [-]
                             nc      = "Obersauer", # [-]
                             numc    = 1,          # [-]
                             use     = "R/I",  # [-]
                             Ages    = 16.5,        # [ha]
                             Ared    = 7.6,  # [ha]
                             tfS     = 10, # [min]
                             pe      = 611, # [PE]
                             Qd      = 9,   # [l/s]
                             V       = 190),  # [m3]
                           ar.model  = ar.model <- list(
                             CODs    = 0.5,#0.9,
                             NH4s    = 0.5,#0.9,
                             CODr    = 0.46),
                           folderOutput = "~/R-output")

MC_setup <- MC.setup(setting_EmiStatR)

sims <- MC.sim(MC_setup, EmiStatR.cores = 0)

## Monte Carlo simulation analysis

# Deterministic simulation
# Definition of structure 1, E1:

E1 <- list(id = 1, ns = "FBH Goesdorf", nm = "Goesdorf", nc = "Obersauer", numc = 1,
           use = "R/I", Ages = 16.5, Ared = 7.6, tfS = 10, pe = 611, Qd = 9, V = 190)

# Definition of the deterministic input:
library(EmiStatR)
data(P1)

input.det <- input(spatial = 0, zero = 1e-5, 
                    folder = system.file("shiny", package = "EmiStatR"),
                    folderOutput ="~/R-output", cores = 0,
                    ww = list(qs = 150, CODs = 104, NH4s = 4.7),
                    inf = list(qf= 0.05, CODf = 0, NH4f = 0),
                    rw = list(CODr = 107, NH4r = 2, stat = "Dahl"),
                    tf = 20, P1 = P1, st = list(E1=E1), export = 0)

# Invoking `EmiStatR` with the deterministic input: 
sim.det   <- EmiStatR(input.det)

# further arguments
delta <- 30 # minutes 
qUpper <- "q999" 
event.ini <- as.POSIXct("2016-01-14")
event.end <- as.POSIXct("2016-01-16 12:00:00")

analysis <- MC.analysis(sims, delta, qUpper,  P1, sim.det, event.ini, event.end, 5)
str(analysis)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Monte Carlo simulation }
\keyword{ MC.analysis }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line