\name{MC.sim}
\docType{methods}
\alias{MC.sim-methods}
\alias{MC.sim,list,numeric-method}
\title{ ~~ Methods for Function \code{MC.sim}  ~~}
\description{
Method to be invoked for running the Monte Carlo simulation. The simulator used is the method \code{EmiStatR}
from the homonym package. This method should be rewritted for working with another simulator.
}
\section{Methods}{
\describe{

\item{\code{signature(x = "list", EmiStatR.cores = "numeric")}}{
%%  ~~describe this method here~~
}
}}

\usage{
MC.sim(x, EmiStatR.cores)
}

\arguments{
  \item{\code{x}}{
   an object of class \code{list} as is defined by method \code{MC.setup}.}
  \item{\code{EmiStatR.cores}}{
   a \code{numeric} value for specifying the number of cores (CPUs) to be used in the EmiStatR method. 
   Use zero for not use parallel computation. See class \code{input} of package \code{EmiStatR} for details. }
}

\value{
  A \code{list} of length 2:
  \item{mc }{A \code{list} that contains the \code{MC_setup}, \code{timing} and \code{lap} objects.}
  \item{sim1 }{A \code{list} that contains the Monte Carlo matrices of the simulator output.}
}

\examples{
## simulation of precipitation time series, P1, within EmiStatR

# loading the precipitation time series P1
library(EmiStatR)
data(P1)

library(STUnc)
setting_EmiStatR <-  setup(id       = "MC_sim1",
                           nsim     = 23,
                           seed     = 0.7010607, 
                           mcCores  = 1, 
                           ts.input = P1,  
                           rng      = rng <- list(
                             qs   = 150,    # [l/PE/d]
                             CODs = c(pdf = "nor", mu = 4.378, sigma = 0.751),    # log[g/PE/d]
                             NH4s = c(pdf = "nor", mu = 1.473, sigma = 0.410),    # log[g/PE/d]
                             qf   = 0.05,           # [l/s/ha]
                             CODf = 0,              # [g/PE/d]
                             NH4f = 0,              # [g/PE/d]
                             CODr = c(pdf = "nor", mu = 3.60, sigma = 1.45),     # log[mg/l]
                             NH4r = 2,              # [mg/l]
                             tf   = 20,             # [min]
                             nameCSO = "E1",        # [-]
                             id      = 1,           # [-]
                             ns      = "FBH Goesdorf",  # [-]
                             nm      = "Goesdorf",  # [-]
                             nc      = "Obersauer", # [-]
                             numc    = 1,           # [-]
                             use     = "R/I",       # [-]
                             Ages    = 16.5,        # [ha]
                             Ared    = 7.6,         # [ha]
                             tfS     = 10,          # [min]
                             pe      = 611,         # [PE]
                             Qd      = 9,           # [l/s]
                             V       = 190),        # [m3]
                           ar.model  = ar.model <- list(
                             CODs    = 0.5,
                             NH4s    = 0.5,
                             CODr    = 0.46),
                           folderOutput = "~/r-output")

MC_setup <- MC.setup(setting_EmiStatR)

sims <- MC.sim(MC_setup, EmiStatR.cores = 0)
str(sims)
}

\keyword{methods}
\keyword{Monte Carlo simulation}
\keyword{MC.sim}
