# Monte-Carlo simulation with pdfs definition
# author: J.A. Torres-Matallana
# organization: Luxembourg Institute of Science and technology (LIST)
#               Wagenigen University and Research Centre (WUR)   
# date: 22.10.2016 - 22.10.2016


setGeneric("MC.sim", function(x, EmiStatR.cores) standardGeneric("MC.sim"))

setMethod("MC.sim", signature = c("list", "numeric"), 
          
          function(x, EmiStatR.cores = 0){
            start    <- Sys.time()
            MC_setup = x
            # MC_setup.dir <- "~/EmiStatR/MC_VAR/input"
            
            ## =================================================================================================================
            ## MC sim year
            ## =================================================================================================================
            # mc.sim <- 1; id <- "MC-WQ_VAR(CODs-NH4s)_AR(CODr)_ts-s-EschSure2010"              # V.Total: V.CODs-NH4s-CODr-P
            # mc.sim <- 2; id <- "MC-WQ_VAR(NH4s)_AR(CODr)_ts-s-EschSure2010";      CODs = 104  # V.CODs:  V.NH4s-CODr-P
            # mc.sim <- 3; id <- "MC-WQ_VAR(CODs)_AR(CODr)_ts-s-EschSure2010";      NH4s = 4.7  # V.NH4s:  V.CODs-CODr-P
            # mc.sim <- 4; id <- "MC-WQ_VAR(CODs-NH4s)_ts-s-EschSure2010";          CODr = 107   # V.CODr:  V.CODs-NH4s-P
            # mc.sim <- 6; id <- "MC-WQ_ts-s-Event7-8"; CODs = 104; NH4s = 4.7; CODr = 107     # V.P
            # load("~/EmiStatR/MC_VAR/input/MC_ts_s_EschSure2010.RData")
            # P1 <- ts.s.EschSure2010
            
            # mc.sim <- 5; id <- "MC-WQ_VAR(CODs-NH4s)_AR(CODr)_ts-s-EschSure2010-526"                   # V.P:     V.CODs-NH4s-CODr
            # load("~/EmiStatR/MC_VAR/input/MC_ts_s_EschSure2010.RData") 
            # P1 <- ts.s.EschSure2010[, c(1,527)]
            # sum(P1[,2])
            # plot(P1[,1], P1[,2], typ="l")
            
            ## =================================================================================================================
            ## MC sim Event7-8
            ## =================================================================================================================
            # mc.sim <- 1; id <- "MC-WQ_VAR(CODs-NH4s)_AR(CODr)_ts-s-Event7-8"              # V.Total: V.CODs-NH4s-CODr-P
            # mc.sim <- 2; id <- "MC-WQ_VAR(NH4s)_AR(CODr)_ts-s-Event7-8";      CODs = 104  # V.CODs:  V.NH4s-CODr-P
            # mc.sim <- 3; id <- "MC-WQ_VAR(CODs)_AR(CODr)_ts-s-Event7-8";      NH4s = 4.7  # V.NH4s:  V.CODs-CODr-P
            # mc.sim <- 4; id <- "MC-WQ_VAR(CODs-NH4s)_ts-s-Event7-8";          CODr = 80   # V.CODr:  V.CODs-NH4s-P
            # mc.sim <- 6; id <- "MC-WQ_ts-s-Event7-8"; CODs = 104; NH4s = 4.7; CODr = 80     # V.P
            # load("~/EmiStatR/MC_VAR/input/ts.s.Event7-8.1min.RData")
            # P1 <- ts.s.Event7_8
            
            # mc.sim <- 5; id <- "MC-WQ_VAR(CODs-NH4s)_AR(CODr)_Event7-8"                   # V.P:     V.CODs-NH4s-CODr
            # load("~/EmiStatR/MC_VAR/input/P1_Event7-8.RData")
            
            ## =================================================================================================================
            ## MC sim Event7-8 - AR models: CODs-NH4s-CODr
            ## =================================================================================================================
            # mc.sim        <- 1; id <- "MC-WQ_AR(CODs-NH4s-CODr)_ts-s-Event7-8"              # V.Total: V.CODs-NH4s-CODr-P
            # mc.sim <- 2; id <- "MC-WQ_AR(NH4s-CODr)_ts-s-Event7-8";      CODs = 104  # V.CODs:  V.NH4s-CODr-P
            # mc.sim <- 3; id <- "MC-WQ_AR(CODs-CODr)_ts-s-Event7-8";      NH4s = 4.7  # V.NH4s:  V.CODs-CODr-P
            # mc.sim <- 4; id <- "MC-WQ_AR(CODs-NH4s)_ts-s-Event7-8";      CODr = 107   # V.CODr:  V.CODs-NH4s-P
            # mc.sim <- 6; id <- "MC-WQ_ts-s-Event7-8";                     CODs = 104; NH4s = 4.7; CODr = 107     # V.P
            # load("~/EmiStatR/MC_VAR/input/ts.s.Event7-8.1min.RData")
            # P1 <- ts.s.Event7_8
            
            # mc.sim <- 5; id <- "MC-WQ_VAR(CODs-NH4s)_AR(CODr)_Event7-8"                   # V.P:     V.CODs-NH4s-CODr
            # load("~/EmiStatR/MC_VAR/input/P1_Event7-8.RData")
            
            ## =================================================================================================================
            ## pe and qs configuration
            ## =================================================================================================================
            ## to create pe and qs time series
            # pe.daily.file <- "~/EmiStatR/MC_VAR/input/pe_factor.csv"
            # qs.daily.file <- "~/EmiStatR/MC_VAR/input/qs_factor.csv"
            # pe.ts.file    <- ""
            # qs.ts.file    <- ""
            
            ## to read pe and qs time series Event7-8
            # pe.daily.file = ""
            # qs.daily.file = ""
            # pe.ts.file    <- "~/EmiStatR/MC_VAR/input/pe_ts_file_Event7-8.csv"
            # qs.ts.file    <- "~/EmiStatR/MC_VAR/input/qs_ts_file_Event7-8.csv"
            
            ## to read pe and qs time series Event7-8
            
            
            #=============================================================================================
            # setting-up MC simulation 
            #=============================================================================================
            
            ## parallel loop for EmiStatR
            
            lap <- matrix(data = NA, nrow = 4, ncol = 2)
            
            cl <- makeCluster(MC_setup[["mcCores"]], outfile="")
            registerDoParallel(cl, cores=MC_setup[["mcCores"]])
            numCores <- detectCores()
            
            # registerDoParallel(cl, cores=i)
            
            # # create progress bar
            # library("tcltk2")
            # pb <- tkProgressBar(title = "progress bar", min = 0, max = nsim, width = 1000)
            nsim <- MC_setup$nsim
            obj1 <- 1:nsim
            
            a <- system.time(
              sim1 <- foreach(obj1 = obj1, .packages = c("EmiStatR"), .export=c("obj1"), 
                              .errorhandling = "pass", .verbose=TRUE, .combine = "rbind") %dopar% {
                                # i <- 1
                                i <- obj1
                                print(paste(i, ", ", MC_setup[["mcCores"]], " cores", sep=""))
                                #                     # update progress bar
                                #                     setTkProgressBar(pb, j, label=paste( round(j/nsim*100, 0), "% done"))
                                
                                #for(i in 1:nsim){
                                
                                #-------------------------------------------------------------------------------------------------------
                                # synthetic precipitation definition
                                #-------------------------------------------------------------------------------------------------------
                                P1 <- MC_setup$ts.input
                                if(ncol(P1) > 2){
                                  P1 <- cbind.data.frame(P1[,1], P1[,i+1])
                                }
                                
                                #-------------------------------------------------------------------------------------------------------
                                # run model (to be modified according to model set-up)
                                #-------------------------------------------------------------------------------------------------------
                                #source("/home/atorres/Documents/02_working/06_LIST-Wageningen_PhD/18_models/01_EmiStat-R/R/genEmiStat-R_valida.R", echo=TRUE)
                                #source(paste(folder,"genEmiStat-R_valida.R", sep=""), echo=TRUE)
                                
                                ## defining Input objet 
                                
                                # defining structure
                                # i <- 1
                                ##***********************************************************************************
                                ## to be updated for general cases (levesl in not pars, exp CODs and NH4s)
                                ##***********************************************************************************
                                # csot <- list(id = setup[["par"]]$id, ns = levels(parsT[["ns"]][i]), nm = levels(parsT[["nm"]][i]),
                                #              nc = levels(parsT[["nc"]][i]), numc = levels(parsT[["numc"]][i]),
                                #              use = levels(parsT[["use"]][i]), Ages = as.numeric(levels(parsT[["Ages"]][i])),
                                #              Ared = as.numeric(parsT[["Ared"]][i]), tfS = as.numeric(levels(parsT[["tfS"]][i])),
                                #              pe = as.numeric(levels(parsT[["pe"]][i])), Qd = as.numeric(levels(parsT[["Qd"]][i])),
                                #              V = as.numeric(levels(parsT[["V"]][i])))
                                
                                # ## Estructure 4 - Goesdorf (deterministic setup)
                                E1 <- list(id = 1, ns = MC_setup[["par"]]$ns, nm = MC_setup[["par"]]$nm,
                                           nc = MC_setup[["par"]]$nc, numc = MC_setup[["par"]]$numc,
                                           use = MC_setup[["par"]]$use, Ages = MC_setup[["par"]]$Ages,
                                           Ared = MC_setup[["par"]]$Ared, tfS = MC_setup[["par"]]$tfS,
                                           pe = MC_setup[["par"]]$pe, Qd = MC_setup[["par"]]$Qd,
                                           V = MC_setup[["par"]]$V)
                                
                                ## defining input objet 
                                
                                input.user <- input(spatial = 0, zero = 1e-5, folder = system.file("shiny", package = "EmiStatR"),
                                                    folderOutput = MC_setup[["folderOutput"]], cores = EmiStatR.cores,
                                                    ww = list(qs = MC_setup[["par"]]$qs, CODs = sample(exp(MC_setup[["par"]][["CODs"]][i,]), 1), 
                                                              NH4s = sample(exp(MC_setup[["par"]][["NH4s"]][i,]), 1)), 
                                                    inf = list(qf= MC_setup[["par"]]$qf, CODf = MC_setup[["par"]]$CODf, 
                                                               NH4f = MC_setup[["par"]]$NH4f),
                                                    rw = list(CODr = sample(exp(MC_setup[["par"]][["CODr"]][i,]),1), NH4r = MC_setup[["par"]]$NH4r, 
                                                              stat = "Esch_Sure2010"), 
                                                    tf = MC_setup[["par"]]$tf, P1 = P1, 
                                                    st = list(E1=E1), 
                                                    export = 0)
                                
                                
                                ##***********************************************************************************
                                ## end
                                ##***********************************************************************************
                                
                                ## executing simulation 
                                #library(EmiStatR)  
                                sim <- EmiStatR(input.user)
                                
                                #-------------------------------------------------------------------------------------------------------
                                # Monte-Carlo output time-series matrix  (to be modified according to model output)
                                #-------------------------------------------------------------------------------------------------------
                                data1 <- sim[[1]]$out1
                                data1 <- data1[,2:ncol(data1)]
                                # head(data1)
                                mcVTank  <- data1[,8]   # V_Tank
                                mcVov    <- data1[,9]   # V_Ov
                                # mcQov    <- data1[,21]  # Q_Ov
                                mcBCODov <- data1[,10]  # B_COD_Ov
                                mcBNH4ov <- data1[,11]  # B_NH4_Ov
                                mcCCODov <- data1[,12]  # C_COD_Ov
                                mcCNH4ov <- data1[,13]  # C_NH4_Ov
                                
                                mc1 <- list(mcVTank=mcVTank, mcVov=mcVov, #mcQov=mcQov, 
                                            mcBCODov=mcBCODov, mcBNH4ov=mcBNH4ov, mcCCODov=mcCCODov, mcCNH4ov=mcCNH4ov,
                                            time = P1[,1], st=E1, inputUser=input.user)
                                
                                return(mc1)
                              } # end of foreach loop for Monte-Carlo simulations
            ) # end system.time
            
            stopCluster(cl)
            # closeAllConnections()
            
            ## end timing
            lap[1,1] <- nsim
            lap[2,1] <- a[3]/60
            lap[3,1] <- EmiStatR.cores
            lap[4,1] <- MC_setup[["mcCores"]]
            lap[1,2] <- "sims"
            lap[2,2] <- "min"
            lap[3,2] <- "cores"
            lap[4,2] <- "MC cores"
            
            end     <- Sys.time()
            elapsed <- difftime(end, start, units="hours"); elapsed
            timing  <- list(start=start, end=end, elapsed_hours=elapsed)
            
            mc <- list(MC_setup = MC_setup)
            mc <- c(mc, list(timing = timing))
            mc <- c(mc, list(lap = lap))
            
            #str(mc)
            #mc["par"]
            #mc["mcVTank"]
            
            #-------------------------------------------------------------------------------------------------------
            # saving outputs
            #-------------------------------------------------------------------------------------------------------
            currentDir <- getwd()
            setwd(MC_setup$folderOutput)
            save(sim1, file=paste("sim1.RData", sep=""))
            save(mc, file=paste("mc.RData", sep=""))
            setwd(currentDir)
            
            ## closing progress bar
            # close(pb)
            print(paste("End of", nsim[length(nsim)], "Monte-Carlo simulations.",sep=" "))
            
            return(list(mc=mc, sim1=sim1))
          }
)
